IF EXISTS ( SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_PG_FORN_BLOQUEIA_FORN_ANONIMIZADO' )
BEGIN
	DROP TRIGGER TRG_PG_FORN_BLOQUEIA_FORN_ANONIMIZADO
END
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 21081901
'Job.................:  
'Nome................: TRG_FP_FUNC_BLOQUEIA_FUNC_ANONIMIZADO 
'Objetivo............: Tratamento para nao alteracao do Fornecedor Anonimizado
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 30/07/2021
'Alterado por........: 
'Criado por..........: Marcos Barros 
'=======================================================================================
*/
CREATE TRIGGER TRG_PG_FORN_BLOQUEIA_FORN_ANONIMIZADO ON PG_FORN FOR UPDATE AS
	DECLARE @CD_FOR INT
	 IF UPDATE (UUID)
	BEGIN
		RETURN;
	END
	SET @CD_FOR = ISNULL((SELECT CD_FORN FROM inserted),0);

	IF EXISTS (SELECT 
					1 
			   FROM 
					LGPD_LOG_PROCESSAMENTO 
				WHERE
					CD_PESSOA = @CD_FOR
					AND TP_PROC = 2)
	  begin
		RAISERROR ('ALTERACAO NO PERMITIDA, CADASTRO ANONIMIZADO!',16, 1);
		ROLLBACK TRANSACTION;
		RETURN;
	  end

GO

ALTER TABLE PG_FORN ENABLE TRIGGER TRG_PG_FORN_BLOQUEIA_FORN_ANONIMIZADO